/*
Copyright 2016 Jun Wako <wakojun@gmail.com>

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#include "print.h"
#include "matrix.h"


__attribute__ ((weak))
uint8_t matrix_rows(void)
{
    return MATRIX_ROWS;
}

__attribute__ ((weak))
uint8_t matrix_cols(void)
{
    return MATRIX_COLS;
}

__attribute__ ((weak))
void matrix_clear(void)
{
}

__attribute__ ((weak))
void matrix_setup(void) {}

__attribute__ ((weak))
bool matrix_is_on(uint8_t row, uint8_t col)
{
    return (matrix_get_row(row) & (1<<col));
}

__attribute__ ((weak))
void matrix_print(void)
{
#if (MATRIX_COLS <= 8)
    print("\n  01234567\n");
#elif (MATRIX_COLS <= 16)
    print("\n  0123456789ABCDEF\n");
#elif (MATRIX_COLS <= 32)
    print("\n  0123456789ABCDEF0123456789ABCDEF\n");
#endif

    for (uint8_t row = 0; row < MATRIX_ROWS; row++) {

#if (MATRIX_COLS <= 8)
        xprintf("%X:%08b%s\n", row&0xF, bitrev(matrix_get_row(row)),
#elif (MATRIX_COLS <= 16)
        xprintf("%X:%016b%s\n", row&0xF, bitrev16(matrix_get_row(row)),
#elif (MATRIX_COLS <= 32)
        xprintf("%X:%032b%s\n", row&0xF, bitrev32(matrix_get_row(row)),
#endif
#ifdef MATRIX_HAS_GHOST
        matrix_has_ghost_in_row(row) ?  " <ghost" : ""
#else
        ""
#endif
        );
    }
}

#ifdef MATRIX_HAS_GHOST
__attribute__ ((weak))
bool matrix_has_ghost_in_row(uint8_t row)
{
    matrix_row_t matrix_row = matrix_get_row(row);
    // No ghost exists when less than 2 keys are down on the row
    if (((matrix_row - 1) & matrix_row) == 0)
        return false;

    // Ghost occurs when the row shares column line with other row
    for (uint8_t i=0; i < MATRIX_ROWS; i++) {
        if (i != row && (matrix_get_row(i) & matrix_row))
            return true;
    }
    return false;
}
#endif

__attribute__ ((weak)) void matrix_power_up(void) {}
__attribute__ ((weak)) void matrix_power_down(void) {}
