KMAC keyboard firmware
======================
Korean custom keyboard designed by Byungho Kim and KBDMania community.

*Note that this is not the official firmware*

Supported models
----------------
At the moment only the TKL models is supported.


Build
-----
Move to this directory then just run `make` like:

    $ make -f Makefile.[pjrc|lufa] [winkey|winkeyless]

Use `Makefile.pjrc` if you want to use PJRC stack or use `Makefile.lufa` for LUFA stack.


Bootloader
---------
The PCB is hardwired to run the bootloader if the key at the `Caps Lock` position is held down when connecting the keyboard.

It is still possible to use Boot Magic and Command to access the bootloader though.


Keymap
------
There are 2 different types of PCB.
They each have their own keymap file.

To customize a keymap:
    1. Edit the file that corresponds to your PCB.
    2. Specify your layout when building.

### 1. Winkey
This is the default keymap.

See [keymap_winkey.h](keymap_winkey.h) for detail.

#### 1.0. Winkey Default Layer
     ,---.   ,---------------. ,---------------. ,---------------. ,-----------.
     |Esc|   |F1 |F2 |F3 |F4 | |F5 |F6 |F7 |F8 | |F9 |F10|F11|F12| |PrS|ScL|Pau|
     `---'   `---------------' `---------------' `---------------' `-----------'
     ,-----------------------------------------------------------. ,-----------.
     |~  |  1|  2|  3|  4|  5|  6|  7|  8|  9|  0|  -|  =|Backsp | |Ins|Hom|PgU|
     |-----------------------------------------------------------| |-----------|
     |Tab  |  Q|  W|  E|  R|  T|  Y|  U|  I|  O|  P|  [|  ]|    \| |Del|End|PgD|
     |-----------------------------------------------------------| '-----------'
     |Fn0   |  A|  S|  D|  F|  G|  H|  J|  K|  L|  ;|  '|Return  |
     |-----------------------------------------------------------|     ,---.
     |Shift   |  Z|  X|  C|  V|  B|  N|  M|  ,|  .|  /|Shift     |     |Up |
     |-----------------------------------------------------------| ,-----------.
     |Ctl|Gui|Alt|             Space             |Alt|Gui|App|Ctl| |Lef|Dow|Rig|
     `-----------------------------------------------------------' `-----------'

#### 1.1. Winkey Media Layer
     ,---.   ,---------------. ,---------------. ,---------------. ,-----------.
     |Led|   |   |   |   |   | |   |   |   |   | |   |   |   |   | |   |   |Slp|
     `---'   `---------------' `---------------' `---------------' `-----------'
     ,-----------------------------------------------------------. ,-----------.
     |   |   |   |   |   |   |   |   |   |   |Mut|V- |V+ |       | |   |   |   |
     |-----------------------------------------------------------| |-----------|
     |     |   |   |   |   |   |   |   |   |Stp|Ply|Prv|Nxt|Media| |   |   |   |
     |-----------------------------------------------------------| '-----------'
     |      |   |   |   |   |   |   |   |   |   |   |   |        |
     |-----------------------------------------------------------|     ,---.
     |        |   |   |Clc|   |   |   |   |   |   |   |Caps      |     |   |
     |-----------------------------------------------------------| ,-----------.
     |   |   |   |                               |   |   |   |   | |   |   |   |
     `-----------------------------------------------------------' `-----------'


### 2. Winkeyless
Layout with 1.5 unit modifiers.

See [keymap_winkeyless.h](keymap_winkeyless.h) for detail.

#### 2.0. Winkeyless Default Layer
     ,---.   ,---------------. ,---------------. ,---------------. ,-----------.
     |Esc|   |F1 |F2 |F3 |F4 | |F5 |F6 |F7 |F8 | |F9 |F10|F11|F12| |PrS|ScL|Pau|
     `---'   `---------------' `---------------' `---------------' `-----------'
     ,-----------------------------------------------------------. ,-----------.
     |~  |  1|  2|  3|  4|  5|  6|  7|  8|  9|  0|  -|  =|Backsp | |Ins|Hom|PgU|
     |-----------------------------------------------------------| |-----------|
     |Tab  |  Q|  W|  E|  R|  T|  Y|  U|  I|  O|  P|  [|  ]|    \| |Del|End|PgD|
     |-----------------------------------------------------------| '-----------'
     |Fn0   |  A|  S|  D|  F|  G|  H|  J|  K|  L|  ;|  '|Return  |
     |-----------------------------------------------------------|     ,---.
     |Shift   |  Z|  X|  C|  V|  B|  N|  M|  ,|  .|  /|Shift     |     |Up |
     |-----------------------------------------------------------| ,-----------.
     |Ctl |Gui|Alt |             Space             |Alt |Gui|Ctl | |Lef|Dow|Rig|
     `-----------------------------------------------------------' `-----------'

#### 2.1. Winkeyless Media Layer
     ,---.   ,---------------. ,---------------. ,---------------. ,-----------.
     |Led|   |   |   |   |   | |   |   |   |   | |   |   |   |   | |   |   |Slp|
     `---'   `---------------' `---------------' `---------------' `-----------'
     ,-----------------------------------------------------------. ,-----------.
     |   |   |   |   |   |   |   |   |   |   |Mut|V- |V+ |       | |   |   |   |
     |-----------------------------------------------------------| |-----------|
     |     |   |   |   |   |   |   |   |   |Stp|Ply|Prv|Nxt|Media| |   |   |   |
     |-----------------------------------------------------------| '-----------'
     |      |   |   |   |   |   |   |   |   |   |   |   |        |
     |-----------------------------------------------------------|     ,---.
     |        |   |   |Clc|   |   |   |   |   |   |   |Caps      |     |   |
     |-----------------------------------------------------------| ,-----------.
     |    |   |    |                               |    |   |    | |   |   |   |
     `-----------------------------------------------------------' `-----------'
